﻿using Spectral1_VBClassLibrary;
using System;
using static Spectral1_VBClassLibrary.DataSet_Spectral;

namespace Spectral1.BUSINESS_LOGIC
{
    public class c_harmonic
    {
        #region "================ DECLARATIONS ========================"
        static CodeGen_DS_Spectral _CGS;

        private Int32 _waveform_set_id = 0;
        private Int32 _note_sector_id = 0;
        private Int32 _intensity_layer_id = 0;
        private Int32 _waveform_id = 0;
        private Int32 _harmonic_id = 0;
        #endregion

        #region "================ PROPERTIES ========================"
        public Int32 waveform_set_id { get { return _waveform_set_id; } }
        public Int32 note_sector_id { get { return _note_sector_id; } }
        public Int32 intensity_layer_id { get { return _intensity_layer_id; } }
        public Int32 waveform_id { get { return _waveform_id; } }
        public Int32 harmonic_id { get { return _harmonic_id; } }

        public Int32 level
        {
            get
            {
                if (r == null)
                {
                    return 0;
                }
                else
                {
                    return r.level;
                }
            }
            set
            {
                if (r != null)
                {
                    if (value < 0) { r.level = 0; }
                    else if (value > 65535) { r.level = 65535; }
                    else r.level = value;
                }
            }
        }

        public bool phase
        {
            get
            {
                if (r == null)
                {
                    return false;
                }
                else
                {
                    if (r.phase_offset == 1) { return true; } else { return false; }
                }
            }
            set
            {
                if (r != null)
                {
                    if (value == true)
                    { r.phase_offset = 1; }
                    else
                    { r.phase_offset = 0; }
                }
            }
        }

        private waveform_harmonicRow r
        {
            get
            {
                return _CGS.Table_waveform_harmonic.GetRow(waveform_set_id, note_sector_id, intensity_layer_id, waveform_id, harmonic_id);
            }
        }
        #endregion

        #region "================ METHODS ========================"

        public c_harmonic(CodeGen_DS_Spectral CGS,Int32 ws, Int32 s, Int32 i, Int32 w, Int32 h)
        {
            _CGS = CGS;
            _waveform_set_id = ws;
            _note_sector_id = s;
            _intensity_layer_id = i;
            _waveform_id = w;
            _harmonic_id = h;
        }

        public void scale_level(double factor)
        {
            level = (Int32)(level * factor);
        }

        public void clear()
        {
            r.level = 0;
            r.phase_offset = 0;
        }

        #endregion
    }
}
